EvaluateSystemScript("colors.js");

// Creates introduction object
function Introduction(fade_speed)
{
	this.events = new Array();
	this.bg = Black;
	this.current_event = 0;
	this.current_process = "FadeFrom";
	this.pressed = false;
	this.timer = 0;
	this.step = 255;
	this.fade_speed = fade_speed;
	this.music = false;
}

// Add a new event to the intro scene
Introduction.prototype.addEvent = function(type, file, wait)
{
	var event = new Object();
	event.type = type;
	if (type == "Image")
	{
		event.file = LoadImage(file);
	}
	if (type == "Text")
	{
		event.file = file;
	}
	if (type == "Animation")
	{
		event.file = new TimedAnimation(LoadAnimation(file));
	}
	event.wait = wait;
	this.events[this.events.length] = event;
}

// Play the intro scene
Introduction.prototype.play = function()
{
	var playing = true;
	if (this.music != false)
	{
		this.music.play(true);
	}
	while (playing)
	{
		ApplyColorMask(this.bg);
		if (this.events[this.current_event] != undefined)
		{
			if (this.events[this.current_event].type == "Image")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.width / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.height / 2));
			}
			if (this.events[this.current_event].type == "Text")
			{
				font.title.drawText(GetScreenWidth() / 2 - (font.title.getStringWidth(this.events[this.current_event].file) / 2), GetScreenHeight() / 2 - 9, this.events[this.current_event].file);
			}
			if (this.events[this.current_event].type == "Animation")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.animation.getWidth() / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.animation.getHeight() / 2));
			}
		}
		// Fade from
		if (this.current_process == "FadeFrom")
		{
			Fade(this.step, Black);
			this.step -= 15;
			if (this.step < 0)
			{
				this.step = 0;
				this.timer = GetTime();
				this.current_process = "Wait";
			}
		}
		if (this.current_process == "Wait")
		{
			if (this.timer + this.events[this.current_event].wait <= GetTime())
			{
				this.current_process = "FadeTo";
			}
		}
		// Fade to
		if (this.current_process == "FadeTo")
		{
			Fade(this.step, Black);
			this.step += 15;
			if (this.step > 255)
			{
				this.step = 255;
				if (this.pressed == false)
				{
					this.current_event ++;
					this.current_process = "FadeFrom";
				}
				if (this.pressed == true)
				{
					playing = false;
				}
			}
		}
		FlipScreen();
		if (this.events[this.current_event] == undefined)
		{
			playing = false;
		}
		if (IsKeyPressed(KEY_ENTER))
		{
			this.current_process = "FadeTo";
			this.pressed = true;
		}
	}
	if (this.music != false)
	{
		this.music.stop();
	}
}

function Fade(step, color)
{
	ApplyColorMask(CreateColor(color.red, color.green, color.blue, step));
}